{********************************************
; File: Desk.p
;
;
; Copyright Apple Computer, Inc. 1986-90
; All Rights Reserved
;
********************************************}

UNIT DESK;

INTERFACE

USES TYPES,QUICKDRAW,EVENTS;

CONST
{ Error Codes }
daNotFound = $0510;  { desk accessory not found }
notSysWindow = $0511;  { not the system window }

{ NDA Action Codes }
eventAction = $0001;
runAction = $0002;
undoAction = $0005;
cutAction = $0006;
copyAction = $0007;
pasteAction = $0008;
clearAction = $0009;
cursorAction = $0003;

{ SystemEdit Codes }
undoEdit = $0001;
cutEdit = $0002;
copyEdit = $0003;
pasteEdit = $0004;
clearEdit = $0005;

PROCEDURE AddToRunQ ( runItemPtr:Ptr)  ;
PROCEDURE ChooseCDA   ;
PROCEDURE CloseAllNDAs   ;
PROCEDURE CloseNDA ( refNum:Integer)  ;
PROCEDURE CloseNDAByWinPtr ( theWindowPtr:WindowPtr)  ;
PROCEDURE DeskBootInit   ;
PROCEDURE DeskReset   ;
PROCEDURE DeskShutDown   ;
PROCEDURE DeskStartUp   ;
FUNCTION DeskStatus  : Boolean ;
FUNCTION DeskVersion  : Integer ;
PROCEDURE FixAppleMenu ( startingID:Integer)  ;
FUNCTION GetDAStrPtr  : Ptr ;
FUNCTION GetNumNDAs  : Integer ;
PROCEDURE InstallCDA ( idHandle:Handle)  ;
PROCEDURE InstallNDA ( idHandle:Handle)  ;
FUNCTION OpenNDA ( idNum:Integer) : Integer ;
PROCEDURE RemoveCDA ( idHandle:Handle)  ;
PROCEDURE RemoveFromRunQ ( runItemPtr:Ptr)  ;
PROCEDURE RemoveNDA ( idHandle:Handle)  ;
PROCEDURE RestAll   ;
PROCEDURE RestScrn   ;
PROCEDURE SaveAll   ;
PROCEDURE SaveScrn   ;
PROCEDURE SetDAStrPtr ( altDispHandle:Handle; stringTablePtr:Ptr)  ;
PROCEDURE SystemClick ( eventRecPtr:EventRecord; theWindowPtr:GrafPortPtr; findWndwResult:Integer)  ;
FUNCTION SystemEdit ( editType:Integer) : Boolean ;
FUNCTION SystemEvent ( eventWhat:Integer; eventMessage:Longint; eventWhen:Longint; eventWhere:Point; eventMods:Integer) : Boolean ;
PROCEDURE SystemTask   ;

IMPLEMENTATION

END.
